<?php
// 1. Error Reporting (সমস্যা দেখার জন্য)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// PHPMailer ফাইলগুলো লোড করা (ফোল্ডার পাথ ঠিক রেখো)
if (!file_exists('PHPMailer/src/Exception.php')) { die("Error: PHPMailer folder not found!"); }

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

// ==========================================================
// ✅ MANUAL CONFIGURATION (এখানে তোমার সেটিংস বসাও)
// ==========================================================
$smtp_host = 'mail.hicktoesp.xyz';   // অথবা 'smtp.gmail.com'
$smtp_user = 'auth@hicktoesp.xyz';   // তোমার ইমেইল
$smtp_pass = 'auth@hicktoesp.xyz';   // তোমার ইমেইলের পাসওয়ার্ড
$smtp_port = 587;                    // পোর্ট (587 বা 465)
$smtp_sec  = 'tls';                  // 'tls' অথবা 'ssl'
$sender_name = "Hickto Esports";     // যে নাম দেখাবে

// মেইল এর বিষয় এবং বডি (ম্যানুয়ালি সেট করো)
$email_subject = "Test Email from Manual Script";
$dummy_username = "Valued User";     // ইমেইলের ভেতরে ইউজারনেম হিসেবে যা দেখাবে
// ==========================================================

$msg = "";
$msg_type = "";

if (isset($_POST['send_test'])) {
    // ফর্ম থেকে শুধু ইমেইলটা নেওয়া হবে
    $target_email = $_POST['email']; 
    
    // টেম্পোরারি পাসওয়ার্ড জেনারেট (শুধু দেখানোর জন্য)
    $new_pass_plain = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 8);

    $mail = new PHPMailer(true);

    try {
        // সার্ভার সেটিংস
        $mail->isSMTP();
        $mail->Host       = $smtp_host;
        $mail->SMTPAuth   = true;
        $mail->Username   = $smtp_user;
        $mail->Password   = $smtp_pass;
        
        if($smtp_sec == 'tls') {
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        } else {
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        }
        
        $mail->Port       = $smtp_port;
        
        // SSL বাইপাস (সার্ভার এরর এড়াতে)
        $mail->SMTPOptions = array(
            'ssl' => array(
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            )
        );

        // প্রাপক এবং প্রেরক
        $mail->setFrom($smtp_user, $sender_name);
        $mail->addAddress($target_email); // ফর্ম থেকে পাওয়া ইমেইল

        // ইমেইল টেম্পলেট (সুন্দর ডিজাইন)
        $email_template = "
        <div style='background-color:#f8fafc; padding:40px; font-family: sans-serif;'>
            <div style='max-width:500px; margin:0 auto; background:white; border-radius:10px; padding:30px; border:1px solid #e2e8f0;'>
                <h2 style='color:#1e293b; margin-bottom:20px; text-align:center;'>Manual Test Email</h2>
                <p style='color:#64748b;'>Hello <strong>$dummy_username</strong>,</p>
                <p style='color:#64748b;'>This is a manual test email sent from your script. Here is a generated code:</p>
                
                <div style='background:#eff6ff; padding:20px; text-align:center; border-radius:8px; margin:25px 0; border: 1px dashed #3b82f6;'>
                    <span style='font-size:24px; font-weight:bold; letter-spacing:2px; color:#2563eb;'>$new_pass_plain</span>
                </div>

                <p style='text-align:center; color:#64748b; font-size:14px;'>If you received this, your PHP Mailer is working perfectly!</p>
            </div>
        </div>";

        $mail->isHTML(true);
        $mail->Subject = $email_subject;
        $mail->Body    = $email_template;

        $mail->send();
        $msg = "Success! Test email sent successfully.";
        $msg_type = "success";
    } catch (Exception $e) {
        $msg = "Mailer Error: " . $mail->ErrorInfo;
        $msg_type = "error";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manual Mail Sender</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style> body { font-family: 'Poppins', sans-serif; background: #f8fafc; } </style>
</head>
<body class="flex items-center justify-center min-h-screen p-6">

    <div class="w-full max-w-md bg-white rounded-3xl shadow-[0_8px_30px_rgb(0,0,0,0.04)] border border-slate-100 p-8 md:p-10">
        
        <div class="text-center mb-8">
            <h1 class="text-3xl font-extrabold text-slate-800 mb-6 tracking-tight">
                TEST <span class="text-blue-600">MAILER</span>
            </h1>

            <h2 class="text-2xl font-bold text-slate-800">Manual Send</h2>
            <p class="text-slate-400 text-sm mt-1">Enter any email to test your SMTP.</p>
        </div>

        <?php if($msg): ?>
            <div class="mb-6 p-4 rounded-xl text-sm font-bold flex items-center gap-3 <?php echo $msg_type == 'error' ? 'bg-red-50 text-red-600' : 'bg-green-50 text-green-600'; ?>">
                <i class="fa-solid <?php echo $msg_type == 'error' ? 'fa-circle-exclamation' : 'fa-check-circle'; ?>"></i>
                <?php echo $msg; ?>
            </div>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-6">
                <label class="block text-xs font-bold text-slate-500 uppercase mb-2 ml-1">Target Email Address</label>
                <div class="relative">
                    <span class="absolute left-4 top-3.5 text-slate-400"><i class="fa-regular fa-envelope"></i></span>
                    <input type="email" name="email" placeholder="receiver@gmail.com" 
                           class="w-full pl-11 pr-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:bg-white focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 outline-none transition font-medium text-slate-800" required>
                </div>
            </div>

            <button type="submit" name="send_test" class="w-full bg-slate-900 text-white py-3.5 rounded-xl font-bold hover:bg-slate-800 transition shadow-lg shadow-slate-200 flex justify-center items-center gap-2">
                <i class="fa-solid fa-paper-plane"></i> Send Test Mail
            </button>
        </form>

    </div>

    <div class="fixed bottom-6 text-center w-full">
        <p class="text-xs text-slate-400">&copy; <?php echo date('Y'); ?> Manual Test Script</p>
    </div>

</body>
</html>
